// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Ol_Onal`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x01E5FF
  ],
  ranges: [
    [0x000964, 0x000965],
    [0x01E5D0, 0x01E5FA]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Ol_Onal}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Ol_Onal}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Onao}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Onao}"
);
testPropertyEscapes(
  /^\p{scx=Ol_Onal}+$/u,
  matchSymbols,
  "\\p{scx=Ol_Onal}"
);
testPropertyEscapes(
  /^\p{scx=Onao}+$/u,
  matchSymbols,
  "\\p{scx=Onao}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x000963],
    [0x000966, 0x00DBFF],
    [0x00E000, 0x01E5CF],
    [0x01E5FB, 0x01E5FE],
    [0x01E600, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Ol_Onal}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Ol_Onal}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Onao}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Onao}"
);
testPropertyEscapes(
  /^\P{scx=Ol_Onal}+$/u,
  nonMatchSymbols,
  "\\P{scx=Ol_Onal}"
);
testPropertyEscapes(
  /^\P{scx=Onao}+$/u,
  nonMatchSymbols,
  "\\P{scx=Onao}"
);

reportCompare(0, 0);
