#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warcraft 2
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250925.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='warcraft-2'
GAME_NAME='Warcraft II: Tides of Darkness'

## The following installers are no longer available for sale from GOG,
## they have been removed when Blizzard released a remaster tied to their DRM system.

ARCHIVE_BASE_FR_0_NAME='setup_warcraft_ii_2.02_v5_(french)_(78104).exe'
ARCHIVE_BASE_FR_0_MD5='346bb75021090767a68902947b4a19ed'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_PART1_NAME='setup_warcraft_ii_2.02_v5_(french)_(78104)-1.bin'
ARCHIVE_BASE_FR_0_PART1_MD5='bffa0de5bf00595a24c1d468c896d393'
ARCHIVE_BASE_FR_0_VERSION='2.02-gog78104'
ARCHIVE_BASE_FR_0_SIZE='711005'

ARCHIVE_BASE_EN_0_NAME='setup_warcraft_ii_2.02_v5_(78104).exe'
ARCHIVE_BASE_EN_0_MD5='6e5f20698076b193f3e94a4f762b361f'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_PART1_NAME='setup_warcraft_ii_2.02_v5_(78104)-1.bin'
ARCHIVE_BASE_EN_0_PART1_MD5='3ac578bac3d490f3994f88311936a544'
ARCHIVE_BASE_EN_0_VERSION='2.02-gog78104'
ARCHIVE_BASE_EN_0_SIZE='732702'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
smackw32.dll
storm.dll
w2local.dll
wsock32.dll
x2local.dll
w2sounds.exe
warcraft ii bne.exe
warcraft ii map editor.exe
battle.snp'
CONTENT_GAME_DATA_FILES='
gamesfx
maps
support
bncache.dat
install.mpq
war2dat.mpq
war2patch.mpq'
CONTENT_DOC_DATA_FILES='
warcraft ii map editor.chm
license.txt
patch.txt'

USER_PERSISTENT_DIRECTORIES='
maps
save'

APP_MAIN_EXE='warcraft ii bne.exe'

APP_EDITOR_ID="${GAME_ID}-editor"
APP_EDITOR_NAME='Warcraft II Map Editor'
APP_EDITOR_EXE='warcraft ii map editor.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_ID="$GAME_ID"
PKG_BIN_ID_EN="${PKG_BIN_ID}-en"
PKG_BIN_ID_FR="${PKG_BIN_ID}-fr"
PKG_BIN_PROVIDES="
$GAME_ID"
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DESCRIPTION_EN='English version'
PKG_BIN_DESCRIPTION_FR='French version'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_EN="${PKG_DATA_ID}-en"
PKG_DATA_ID_FR="${PKG_DATA_ID}-fr"
PKG_DATA_PROVIDES="
$PKG_DATA_ID"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DESCRIPTION_EN="$PKG_DATA_DESCRIPTION - English version"
PKG_DATA_DESCRIPTION_FR="$PKG_DATA_DESCRIPTION - French version"

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
