# FindQScintilla.cmake
cmake_minimum_required(VERSION 3.16)

find_package(Qt6 QUIET COMPONENTS Core)


message(STATUS "Now looking for the QScintilla library")

# Find include directory
find_path(QSCINTILLA_INCLUDE_DIR
  NAMES qsciscintilla.h
  PATHS
    /usr/include/Qsci
    /usr/include/qt6/Qsci
    /usr/include/${CMAKE_LIBRARY_ARCHITECTURE}/Qsci
    /usr/include/${CMAKE_LIBRARY_ARCHITECTURE}/qt6/Qsci
    /usr/local/include/Qsci
    /usr/local/include/qt6/Qsci
    /usr/local/include/${CMAKE_LIBRARY_ARCHITECTURE}/Qsci
    /usr/local/include/${CMAKE_LIBRARY_ARCHITECTURE}/qt6/Qsci
  PATH_SUFFIXES Qsci
)

message(STATUS "The libqscintilla2-qt6 include dir: ${QSCINTILLA_INCLUDE_DIR}")

# Find library with version-specific search
set(_qscintilla_lib_names)
  list(APPEND _qscintilla_lib_names
    qscintilla2_qt6
    libqscintilla2_qt6
  )

# Add fallback names
list(APPEND _qscintilla_lib_names
  qscintilla2
  libqscintilla2
)

find_library(QSCINTILLA_LIBRARY
  NAMES ${_qscintilla_lib_names}
  HINTS
    /usr/lib/${CMAKE_LIBRARY_ARCHITECTURE}
    /usr/local/lib/${CMAKE_LIBRARY_ARCHITECTURE}
    /usr/lib
    /usr/local/lib
)

# Handle found components
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(QScintilla
  REQUIRED_VARS QSCINTILLA_LIBRARY QSCINTILLA_INCLUDE_DIR
  VERSION_VAR QSCINTILLA_VERSION_STRING
)

if(QSCINTILLA_FOUND)
  set(QSCINTILLA_INCLUDE_DIRS ${QSCINTILLA_INCLUDE_DIR})
  set(QSCINTILLA_LIBRARIES ${QSCINTILLA_LIBRARY})

  # Create imported target
  if(NOT TARGET QScintilla::QScintilla)
    add_library(QScintilla::QScintilla UNKNOWN IMPORTED)
    set_target_properties(QScintilla::QScintilla PROPERTIES
      IMPORTED_LOCATION "${QSCINTILLA_LIBRARIES}"
      INTERFACE_INCLUDE_DIRECTORIES "${QSCINTILLA_INCLUDE_DIRS}"
      # This is to tell the build process we want to import the lib symbols.
      INTERFACE_COMPILE_DEFINITIONS "QSCINTILLA_DLL"
    )

    # Link against required Qt components
    find_package(Qt6 REQUIRED COMPONENTS Core Widgets)
    set_target_properties(QScintilla::QScintilla PROPERTIES
      INTERFACE_LINK_LIBRARIES "Qt6::Core;Qt6::Widgets"
    )
  endif()
endif()
