/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Color;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import rene.lister.Element;
import rene.util.FileName;
import rene.util.MyVector;
import rene.util.sort.SortObject;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.construction.DepList;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.ExpressionString;
import rene.zirkel.expression.NoValueException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.Conditional;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;

public class ConstructionObject
implements Cloneable,
SortObject,
Element {
    protected int ColorType = 0;
    public static final int NORMAL = 0;
    public static final int THICK = 1;
    public static final int THIN = 2;
    public static final int INVISIBLE = 3;
    protected Color C = Color.black;
    protected int ColorIndex = 0;
    protected boolean Selected = false;
    protected boolean StrongSelected = false;
    protected boolean Indicated = false;
    protected boolean ShowIndicatedName = false;
    protected boolean LabelSelected = false;
    protected boolean Valid = true;
    protected boolean Hidden = false;
    protected boolean SuperHidden = false;
    protected boolean BreakHide = false;
    protected boolean ShowName = false;
    protected boolean ShowValue = false;
    protected boolean Selectable = true;
    protected String Name = "Generic";
    protected static int Count = 1;
    protected String Text = "???";
    private int XOffset = 0;
    private int YOffset = 0;
    protected double XcOffset = 0.0;
    protected double YcOffset = 0.0;
    protected boolean KeepClose;
    protected boolean DisplaysText = false;
    protected double TX1;
    protected double TY1;
    protected double TX2;
    protected double TY2;
    protected Construction Cn;
    protected boolean MainParameter;
    protected boolean Parameter;
    protected boolean Target;
    public boolean Flag;
    public boolean RekFlag;
    public boolean IsDrawn;
    public boolean HasZ;
    public int Scratch;
    protected boolean Keep = false;
    protected boolean JobTarget = false;
    protected ConstructionObject Translation;
    protected boolean Back = false;
    protected boolean Obtuse = true;
    protected boolean Break = false;
    protected boolean HideBreak = false;
    protected boolean Solid = false;
    static Count N = new Count();
    protected boolean inConstruction;
    protected String Unit = "";
    protected boolean Bold = false;
    protected boolean Large = false;
    protected Vector Conditionals;
    protected int NCount = 0;
    protected boolean gotNCount = false;
    public static DepList DL = new DepList();
    int OldColorIndex;
    public double Value = 1000.0;
    ExpressionString AliasES = null;
    public MyVector VRek;
    public boolean RekValidating = false;
    public static final int DescriptionState = 0;
    public static final int FormulaState = 1;
    public static final int SizeState = 2;
    public boolean SpecialParameter = false;
    MyVector MV;
    boolean MVInUse = false;

    public boolean isGotNCount() {
        return this.gotNCount;
    }

    public void setGotNCount(boolean bl) {
        this.gotNCount = bl;
    }

    public ConstructionObject(Construction construction) {
        this.Cn = construction;
        this.inConstruction = true;
        this.setName();
    }

    public ConstructionObject(Construction construction, String string) {
        this.Cn = construction;
        this.inConstruction = true;
        this.setName(string);
    }

    public void setName() {
        this.Name = this.Cn.LongNames ? Zirkel.name("name." + this.getTag()) + " " + this.getN() : Zirkel.name("name.short." + this.getTag()) + this.getN();
    }

    public int getN() {
        return N.next();
    }

    public String getTag() {
        return "Generic";
    }

    public ConstructionObject getTranslation() {
        return this.Translation;
    }

    public void setTranslation(ConstructionObject constructionObject) {
        this.Translation = constructionObject;
    }

    public void translate() {
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return false;
    }

    public boolean nearto(int n, int n2, boolean bl, ZirkelCanvas zirkelCanvas) {
        return this.nearto(n, n2, zirkelCanvas);
    }

    public boolean onlynearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return true;
    }

    public boolean textcontains(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (!this.DisplaysText || !this.Valid || this.isHidden() && !zirkelCanvas.showHidden()) {
            return false;
        }
        return (double)n > this.TX1 && (double)n < this.TX2 && (double)n2 > this.TY1 && (double)n2 < this.TY2;
    }

    public void setSelected(boolean bl) {
        this.Selected = bl;
        this.StrongSelected = false;
    }

    public void setStrongSelected(boolean bl) {
        this.StrongSelected = bl;
    }

    public boolean isStrongSelected() {
        return this.StrongSelected;
    }

    public boolean selected() {
        return this.Selected || this.StrongSelected;
    }

    public void setLabelSelected(boolean bl) {
        this.LabelSelected = bl;
    }

    public boolean isSelectable() {
        return this.valid() && !this.JobTarget && this.Selectable;
    }

    public void validate() {
        this.Valid = true;
    }

    public boolean valid() {
        return this.Valid;
    }

    public boolean displays(ZirkelCanvas zirkelCanvas) {
        if (this.SuperHidden) {
            return false;
        }
        if (!zirkelCanvas.showHidden() && (this.testConditional("hidden") || this.testConditional("superhidden"))) {
            return false;
        }
        return this.Valid && !this.BreakHide && (!this.Hidden || zirkelCanvas.showHidden());
    }

    public boolean indicated() {
        return this.Indicated;
    }

    public void setIndicated(boolean bl) {
        this.Indicated = bl;
    }

    public void setIndicated(boolean bl, boolean bl2) {
        this.Indicated = bl;
        this.ShowIndicatedName = bl2;
    }

    public double changedBy() {
        return 0.0;
    }

    public static String text1(String string, String string2) {
        StringTokenizer stringTokenizer = ConstructionObject.tokenize(string);
        String string3 = "Illegal Format";
        try {
            string3 = stringTokenizer.nextToken() + string2;
            string3 = string3 + stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3.trim();
    }

    public static String text2(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = ConstructionObject.tokenize(string);
        String string4 = "Illegal Format";
        try {
            string4 = stringTokenizer.nextToken() + string2 + stringTokenizer.nextToken() + string3;
            string4 = string4 + stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string4.trim();
    }

    public static String text3(String string, String string2, String string3, String string4) {
        StringTokenizer stringTokenizer = ConstructionObject.tokenize(string);
        String string5 = "Illegal Format";
        try {
            string5 = stringTokenizer.nextToken() + string2 + stringTokenizer.nextToken() + string3 + stringTokenizer.nextToken() + string4;
            string5 = string5 + stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string5.trim();
    }

    public static String text4(String string, String string2, String string3, String string4, String string5) {
        StringTokenizer stringTokenizer = ConstructionObject.tokenize(string);
        String string6 = "Illegal Format";
        try {
            string6 = stringTokenizer.nextToken() + string2 + stringTokenizer.nextToken() + string3 + stringTokenizer.nextToken() + string4 + stringTokenizer.nextToken() + string5;
            string6 = string6 + stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string6;
    }

    public static String textAny(String string, String[] stringArray) {
        StringTokenizer stringTokenizer = ConstructionObject.tokenize(string);
        String string2 = "Illegal Format";
        try {
            string2 = stringTokenizer.nextToken();
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i];
                if (i >= stringArray.length - 1) continue;
                string2 = string2 + ", ";
            }
            string2 = string2 + stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private static StringTokenizer tokenize(String string) {
        if (string.startsWith("%")) {
            string = " " + string;
        }
        if (string.endsWith("%")) {
            string = string + " ";
        }
        return new StringTokenizer(string, "%");
    }

    public void setText(String string, boolean bl) {
        if (!bl && this.Text.endsWith(" ")) {
            return;
        }
        this.Text = string;
    }

    public void setText(String string) {
        this.setText(string, false);
    }

    public String getText() {
        return this.Text;
    }

    public boolean labelSelected() {
        return this.LabelSelected;
    }

    public void setColor(int n) {
        if (n < 0) {
            this.C = Color.pink;
        } else {
            this.C = this.ColorType == 2 ? ZirkelFrame.LightColors[n] : ZirkelFrame.Colors[n];
            this.ColorIndex = n;
        }
    }

    public int getColorIndex(boolean bl) {
        if (!bl && this.haveConditionals()) {
            for (int i = 0; i < ZirkelFrame.ColorStrings.length; ++i) {
                if (!this.testConditional(ZirkelFrame.ColorStrings[i])) continue;
                return i;
            }
        }
        return this.ColorIndex;
    }

    public int getColorIndex() {
        return this.getColorIndex(false);
    }

    public Color getColor() {
        if (this.isJobTarget()) {
            return ZirkelFrame.TargetColor;
        }
        if (this.selected()) {
            return ZirkelFrame.SelectColor;
        }
        if (this.getColorType() == 2) {
            int n = this.getColorIndex();
            if (this.isHidden()) {
                return ZirkelFrame.BrighterLightColors[n];
            }
            return ZirkelFrame.LightColors[n];
        }
        int n = this.getColorIndex();
        if (this.isHidden()) {
            return ZirkelFrame.BrighterColors[n];
        }
        return ZirkelFrame.Colors[n];
    }

    public boolean mustHide(ZirkelCanvas zirkelCanvas) {
        if (!this.Valid) {
            return true;
        }
        if (this.ColorIndex > 0 && zirkelCanvas.getShowColor() != 0 && zirkelCanvas.getShowColor() != this.ColorIndex) {
            return true;
        }
        if (this.JobTarget && this.Hidden) {
            return true;
        }
        return this.SuperHidden || this.testConditional("superhidden") || this.BreakHide || zirkelCanvas.hides(this) || this.isHidden() && !zirkelCanvas.showHidden();
    }

    public void setHidden(boolean bl) {
        this.Hidden = bl;
        if (!bl) {
            this.SuperHidden = false;
        }
    }

    public void setSuperHidden(boolean bl) {
        this.SuperHidden = bl;
    }

    public void toggleHidden() {
        boolean bl = this.Hidden = !this.Hidden;
        if (!this.Hidden) {
            this.SuperHidden = false;
        }
    }

    public boolean isHidden(boolean bl) {
        if (!bl && this.testConditional("visible")) {
            return false;
        }
        if (!bl && (this.testConditional("hidden") || this.testConditional("superhidden"))) {
            return true;
        }
        return this.Hidden || this.SuperHidden;
    }

    public boolean isHidden() {
        return this.isHidden(false);
    }

    public boolean isSuperHidden(boolean bl) {
        if (!bl && this.testConditional("superhidden")) {
            return true;
        }
        return this.SuperHidden;
    }

    public boolean isSuperHidden() {
        return this.isSuperHidden(false);
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String string) {
        this.Name = "";
        if (this.Cn != null) {
            ConstructionObject constructionObject = this.Cn.find(string);
            while (constructionObject != null && constructionObject != this) {
                string = string + "*";
                constructionObject = this.Cn.find(string);
            }
        }
        this.Name = string;
    }

    public void setNameCheck(String string) throws ConstructionException {
        ConstructionObject constructionObject;
        boolean bl = false;
        this.Name = "";
        if (this.Cn != null && (constructionObject = this.Cn.find(string)) != null && constructionObject != this) {
            string = string + "*";
            constructionObject = this.Cn.find(string);
            bl = true;
        }
        this.Name = string;
        if (bl) {
            throw new ConstructionException(Zirkel.name("exception.double"));
        }
    }

    public void setNameWithNumber(String string) {
        this.Name = "";
        if (this.Cn != null) {
            ConstructionObject constructionObject = this.Cn.find(string);
            if (constructionObject != null) {
                while (constructionObject != null && constructionObject != this) {
                    this.setName();
                    string = this.Name;
                    this.Name = "";
                    constructionObject = this.Cn.find(string);
                }
                this.Name = string;
            } else {
                this.Name = string;
            }
        } else {
            this.Name = string;
        }
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.repaint();
    }

    public void drawLabel(MyGraphics myGraphics, String string) {
        myGraphics.drawStringExtended(string, this.TX1, this.TY1);
        this.TX2 = this.TX1 + (double)myGraphics.stringWidth(string);
        this.TY2 = this.TY1 + (double)myGraphics.stringHeight(string);
    }

    public void setFont(MyGraphics myGraphics) {
        myGraphics.setFont(this.Large, this.Bold);
    }

    public void drawCenteredLabel(MyGraphics myGraphics, String string, ZirkelCanvas zirkelCanvas, double d2, double d3, double d4, double d5) {
        int n = myGraphics.stringWidth(string);
        int n2 = myGraphics.stringHeight(string);
        this.TX1 = zirkelCanvas.col(d2 + d4) - (double)(n / 2);
        this.TY1 = zirkelCanvas.row(d3 + d5) - (double)(n2 / 2);
        myGraphics.drawStringExtended(string, this.TX1, this.TY1);
        this.TX2 = this.TX1 + (double)n;
        this.TY2 = this.TY1 + (double)n2;
    }

    public void drawLabel(MyGraphics myGraphics, String string, ZirkelCanvas zirkelCanvas, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        int n = myGraphics.stringWidth(string);
        int n2 = myGraphics.stringHeight(string);
        double d9 = zirkelCanvas.dx(n);
        double d10 = zirkelCanvas.dy(n2);
        double d11 = Math.abs(-d9 * d5 + d10 * d4);
        double d12 = Math.abs(d9 * d5 + d10 * d4);
        if (d12 > (d8 = d11)) {
            d8 = d12;
        }
        double d13 = zirkelCanvas.dy(2.0 * zirkelCanvas.pointSize());
        this.TX1 = zirkelCanvas.col(d2 - d5 * (d8 + 3.0 * d13) / 2.0 + d6) - (double)(n / 2);
        this.TY1 = zirkelCanvas.row(d3 + d4 * (d8 + 3.0 * d13) / 2.0 + d7) - (double)(n2 / 2);
        myGraphics.drawStringExtended(string, this.TX1, this.TY1);
        this.TX2 = this.TX1 + (double)n;
        this.TY2 = this.TY1 + (double)n2;
    }

    public void drawPointLabel(MyGraphics myGraphics, String string, ZirkelCanvas zirkelCanvas, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        int n = myGraphics.stringWidth(string);
        int n2 = myGraphics.stringHeight(string);
        double d9 = zirkelCanvas.dx(n);
        double d10 = zirkelCanvas.dy(n2);
        double d11 = Math.abs(-d9 * d5 + d10 * d4);
        double d12 = Math.abs(d9 * d5 + d10 * d4);
        if (d12 > (d8 = d11)) {
            d8 = d12;
        }
        double d13 = zirkelCanvas.dy(2.0 * zirkelCanvas.pointSize());
        if (Math.abs(d8 * d4) > d10 + 2.0 * d13) {
            d8 = Math.abs((d10 + 2.0 * d13) / d4);
        }
        double d14 = d2 - d5 * d8 / 2.0;
        double d15 = d3 + d4 * d8 / 2.0;
        this.TX1 = zirkelCanvas.col(d14 - d5 * d13 * 1.5 + d6) - (double)(n / 2);
        this.TY1 = zirkelCanvas.row(d15 + d4 * d13 * 1.5 + d7) - (double)(n2 / 2);
        myGraphics.drawStringExtended(string, this.TX1, this.TY1);
        this.TX2 = this.TX1 + (double)n;
        this.TY2 = this.TY1 + (double)n2;
    }

    public void save(XmlWriter xmlWriter) {
        xmlWriter.startTagStart(this.getTag());
        xmlWriter.printArg("name", this.Name);
        if (this.AliasES != null) {
            xmlWriter.printArg("alias", this.AliasES.toString());
        }
        xmlWriter.printArg("n", "" + this.NCount);
        if (this.ColorIndex != 0) {
            xmlWriter.printArg("color", "" + this.ColorIndex);
        }
        if (this.ColorType == 1) {
            xmlWriter.printArg("type", "thick");
        }
        if (this.ColorType == 2) {
            xmlWriter.printArg("type", "thin");
        }
        if (this.ColorType == 3) {
            xmlWriter.printArg("type", "invisible");
        }
        if (this.SuperHidden) {
            xmlWriter.printArg("hidden", "super");
        } else if (this.Hidden) {
            xmlWriter.printArg("hidden", "true");
        }
        if (this.ShowName) {
            xmlWriter.printArg("showname", "true");
        }
        if (this.ShowValue) {
            xmlWriter.printArg("showvalue", "true");
        }
        if (this.Back) {
            xmlWriter.printArg("background", "true");
        }
        if (this.XcOffset != 0.0) {
            xmlWriter.printArg("xcoffset", "" + this.XcOffset);
        }
        if (this.YcOffset != 0.0) {
            xmlWriter.printArg("ycoffset", "" + this.YcOffset);
        }
        if (this.KeepClose) {
            xmlWriter.printArg("keepclose", "true");
        }
        if (this.Parameter) {
            xmlWriter.printArg("parameter", "true");
        }
        if (this.MainParameter) {
            xmlWriter.printArg("mainparameter", "true");
        }
        if (this.Target) {
            xmlWriter.printArg("target", "true");
        }
        if (this.Break) {
            if (this.HideBreak) {
                xmlWriter.printArg("hidebreak", "true");
            } else {
                xmlWriter.printArg("break", "true");
            }
        }
        if (this.Solid && this.maybeTransparent() && this.isFilled()) {
            xmlWriter.printArg("solid", "true");
        }
        if (!this.Unit.equals("")) {
            xmlWriter.printArg("unit", this.Unit);
        }
        if (this.Bold) {
            xmlWriter.printArg("bold", "true");
        }
        if (this.Large) {
            xmlWriter.printArg("large", "true");
        }
        if (this.haveConditionals()) {
            int n = 0;
            Enumeration enumeration = this.Conditionals.elements();
            while (enumeration.hasMoreElements()) {
                Conditional conditional = (Conditional)enumeration.nextElement();
                xmlWriter.printArg("ctag" + n, conditional.getTag());
                xmlWriter.printArg("cexpr" + n, conditional.getExpression().toString());
                ++n;
            }
        }
        this.printArgs(xmlWriter);
        xmlWriter.startTagEnd();
        xmlWriter.print(this.Text);
        xmlWriter.endTag(this.getTag());
        xmlWriter.println();
    }

    public void printArgs(XmlWriter xmlWriter) {
    }

    public void updateText() {
    }

    public void setConstruction(Construction construction) {
        this.Cn = construction;
        this.inConstruction = true;
        this.setNameWithNumber(this.Name);
    }

    public boolean showName(boolean bl) {
        if (!bl && this.testConditional("showname")) {
            return true;
        }
        return this.ShowName || this.Indicated && this.ShowIndicatedName;
    }

    public boolean showName() {
        return this.showName(false);
    }

    public void setShowName(boolean bl) {
        this.ShowName = bl;
    }

    public boolean showValue(boolean bl) {
        if (!bl && this.testConditional("showvalue")) {
            return true;
        }
        return this.ShowValue;
    }

    public boolean showValue() {
        return this.showValue(false);
    }

    public void setShowValue(boolean bl) {
        this.ShowValue = bl;
    }

    public String getDisplayText() {
        String string = this.Name;
        if (this.AliasES != null) {
            string = this.AliasES.evaluate();
        } else if (string.indexOf("~") > 0) {
            string = string.substring(0, string.indexOf("~"));
        }
        if (this.showName()) {
            if (this.showValue()) {
                String string2 = this.getDisplayValue();
                if (string2.equals("")) {
                    return string;
                }
                if (string.endsWith("$")) {
                    string = string.substring(0, string.length() - 1);
                }
                string = string.endsWith("_") && string.length() > 1 ? string.substring(0, string.length() - 1) : string + " = ";
                if (this.Unit.equals("")) {
                    return string + this.getDisplayValue();
                }
                return string + this.getDisplayValue() + this.Unit;
            }
            if (string.indexOf("~") > 0 && this.AliasES == null) {
                string = string.substring(0, string.indexOf("~"));
            }
            return string;
        }
        if (this.showValue()) {
            if (this.Unit.equals("")) {
                return this.getDisplayValue();
            }
            return this.getDisplayValue() + this.Unit;
        }
        return "";
    }

    public String replaceExpressions(String string) {
        boolean bl = string.startsWith("$");
        int n = 0;
        while (string.indexOf("%", n) >= 0) {
            int n2 = string.indexOf("%", n);
            String string2 = string.substring(n2 + 1);
            int n3 = string2.indexOf("%");
            if (n3 == 0) {
                string = string.substring(0, n2) + "%" + string2.substring(1);
                ++n;
                continue;
            }
            if (n3 < 0) break;
            String string3 = string2.substring(0, n3);
            boolean bl2 = false;
            boolean bl3 = false;
            if (string3.startsWith("~")) {
                string3 = string3.substring(1);
                bl2 = true;
            } else if (string3.startsWith("+")) {
                string3 = string3.substring(1);
                bl3 = true;
            }
            ConstructionObject constructionObject = this.getConstruction().find(string3);
            String string4 = "";
            if (constructionObject != null) {
                DL.add(constructionObject);
            }
            try {
                if (bl2) {
                    string4 = constructionObject.getEquation();
                } else if (constructionObject != null) {
                    double d2 = this.round(constructionObject.getValue());
                    if (bl3 && d2 >= 0.0) {
                        string4 = "+";
                    }
                    string4 = d2 == Math.floor(d2 + 0.1) ? string4 + (int)d2 : string4 + d2;
                } else {
                    Expression expression = new Expression(string3, this.getConstruction(), this);
                    if (expression.isValid()) {
                        Enumeration enumeration = expression.getDepList().elements();
                        while (enumeration.hasMoreElements()) {
                            DL.add((ConstructionObject)enumeration.nextElement());
                        }
                    }
                    double d3 = this.round(expression.getValue());
                    if (bl3 && d3 >= 0.0) {
                        string4 = "+";
                    }
                    string4 = d3 == Math.floor(d3 + 0.1) ? string4 + (int)d3 : string4 + d3;
                }
            }
            catch (Exception exception) {
                string4 = bl ? "\\circ" : "???";
            }
            string = string.substring(0, n2) + string4 + string2.substring(n3 + 1);
            n = n2 + string4.length();
        }
        return string;
    }

    public void addDepInExpressions(String string) {
        this.replaceExpressions(string);
    }

    public String translateExpressions(String string) {
        boolean bl = string.startsWith("$");
        int n = 0;
        while (string.indexOf("%", n) >= 0) {
            int n2 = string.indexOf("%", n);
            String string2 = string.substring(n2 + 1);
            int n3 = string2.indexOf("%");
            if (n3 == 0) {
                string = string.substring(0, n2) + "%" + string2.substring(1);
                ++n;
                continue;
            }
            if (n3 < 0) break;
            String string3 = string2.substring(0, n3);
            boolean bl2 = false;
            boolean bl3 = false;
            String string4 = "";
            if (string3.startsWith("~")) {
                string3 = string3.substring(1);
                bl2 = true;
                string4 = "+";
            } else if (string3.startsWith("+")) {
                string3 = string3.substring(1);
                bl3 = true;
                string4 = "~";
            }
            ConstructionObject constructionObject = this.getConstruction().find(string3);
            if (constructionObject != null) {
                constructionObject = constructionObject.getTranslation();
            }
            if (bl2) {
                string4 = string4 + constructionObject.getName();
            } else if (constructionObject != null) {
                string4 = string4 + constructionObject.getName();
            } else {
                Expression expression = new Expression(string3, this.getConstruction(), this);
                if (expression.isValid()) {
                    expression.translate();
                    string4 = string4 + expression.toString();
                } else {
                    return string;
                }
            }
            string = string.substring(0, n2) + "%" + string4 + "%" + string2.substring(n3 + 1);
            n = n2 + string4.length() + 2;
        }
        return string;
    }

    public String getDisplayValue() {
        return "";
    }

    public String getSizeDisplay() {
        return this.getDisplayValue() + this.getUnit();
    }

    public double round(double d2) {
        return this.round(d2, ZirkelCanvas.EditFactor);
    }

    public double roundDisplay(double d2) {
        return this.round(d2, ZirkelCanvas.LengthsFactor);
    }

    public double round(double d2, double d3) {
        return (double)Math.round(d2 * d3) / d3;
    }

    public void setcOffset(double d2, double d3) {
        this.XcOffset = d2;
        this.YcOffset = d3;
    }

    public double xcOffset() {
        return this.XcOffset;
    }

    public double ycOffset() {
        return this.YcOffset;
    }

    public void setOffset(int n, int n2) {
        this.XOffset = n;
        this.YOffset = n2;
    }

    public boolean isKeepClose() {
        return this.KeepClose;
    }

    public void setKeepClose(double d2, double d3) {
        this.KeepClose = true;
        this.XcOffset = d2;
        this.YcOffset = d3;
    }

    public void setKeepClose(boolean bl) {
        if (this.KeepClose && !bl) {
            this.XcOffset = 0.0;
            this.YcOffset = 0.0;
        }
        this.KeepClose = bl;
    }

    public boolean canKeepClose() {
        return false;
    }

    public void translateOffset(ZirkelCanvas zirkelCanvas) {
        if (this.XOffset != 0 || this.YOffset != 0) {
            this.XcOffset = zirkelCanvas.dx(this.XOffset);
            this.YcOffset = zirkelCanvas.dy(-this.YOffset);
            this.YOffset = 0;
            this.XOffset = 0;
        }
    }

    public int getColorType(boolean bl) {
        if (!bl && this.testConditional("thin")) {
            return 2;
        }
        if (!bl && this.testConditional("thick")) {
            return 1;
        }
        if (!bl && this.testConditional("normal")) {
            return 0;
        }
        return this.ColorType;
    }

    public int getColorType() {
        return this.getColorType(false);
    }

    public void setColorType(int n) {
        this.ColorType = n;
        this.setColor(this.ColorIndex);
    }

    public boolean isParameter() {
        return this.Parameter || this.MainParameter;
    }

    public boolean isMainParameter() {
        return this.MainParameter;
    }

    public void clearParameter() {
        this.Parameter = false;
        this.MainParameter = false;
    }

    public void setMainParameter() {
        Enumeration enumeration = this.secondaryParams();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            constructionObject.setParameter();
        }
        this.MainParameter = true;
    }

    public void setParameter() {
        this.Parameter = true;
    }

    public Enumeration depending() {
        DL.reset();
        if (this.haveConditionals()) {
            Enumeration enumeration = this.Conditionals.elements();
            while (enumeration.hasMoreElements()) {
                Conditional conditional = (Conditional)enumeration.nextElement();
                Enumeration enumeration2 = conditional.getExpression().getDepList().elements();
                while (enumeration2.hasMoreElements()) {
                    DL.add((ConstructionObject)enumeration2.nextElement());
                }
            }
        }
        if (this.AliasES != null) {
            this.AliasES.addDep(this);
        }
        return DL.elements();
    }

    public boolean dependsOn(ConstructionObject constructionObject) {
        Enumeration enumeration = this.depending();
        while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject2 = (ConstructionObject)enumeration.nextElement();
            if (constructionObject2 != constructionObject) continue;
            return true;
        }
        return false;
    }

    public Enumeration secondaryParams() {
        DL.reset();
        return DL.elements();
    }

    public ConstructionObject[] getDepArray() {
        this.depending();
        return DL.getArray();
    }

    public Enumeration depset(ConstructionObject constructionObject) {
        DL.add(constructionObject);
        return DL.elements();
    }

    public Enumeration depset(ConstructionObject constructionObject, ConstructionObject constructionObject2) {
        DL.add(constructionObject);
        DL.add(constructionObject2);
        return DL.elements();
    }

    public Enumeration depset(ConstructionObject constructionObject, ConstructionObject constructionObject2, ConstructionObject constructionObject3) {
        DL.add(constructionObject);
        DL.add(constructionObject2);
        DL.add(constructionObject3);
        return DL.elements();
    }

    public void setFlag(boolean bl) {
        this.Flag = bl;
    }

    public boolean isFlag() {
        return this.Flag;
    }

    public void setRekFlag(boolean bl) {
        this.RekFlag = bl;
    }

    public boolean isRekFlag() {
        return this.RekFlag;
    }

    public void setTarget(boolean bl) {
        this.Target = bl;
    }

    public boolean isTarget() {
        return this.Target;
    }

    public void setKeep(boolean bl) {
        this.Keep = bl;
    }

    public boolean isKeep() {
        return this.Keep;
    }

    public boolean equals(ConstructionObject constructionObject) {
        return false;
    }

    public boolean equals(double d2, double d3) {
        return Math.abs(d2 - d3) < 1.0E-8;
    }

    public void setJobTarget(boolean bl) {
        if (bl) {
            this.OldColorIndex = this.ColorIndex;
            this.setColor(-1);
        } else if (this.JobTarget) {
            this.setColor(this.OldColorIndex);
        }
        this.JobTarget = bl;
    }

    public boolean isJobTarget() {
        return this.JobTarget;
    }

    public void updateCircleDep() {
    }

    public void clearCircleDep() {
    }

    public ConstructionObject copy() {
        ConstructionObject constructionObject = null;
        try {
            constructionObject = (ConstructionObject)this.clone();
            this.setTranslation(constructionObject);
            constructionObject.translateConditionals();
            constructionObject.translate();
            constructionObject.setName();
            constructionObject.updateText();
            constructionObject.setBreak(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return constructionObject;
    }

    public Construction getConstruction() {
        return this.Cn;
    }

    public double getValue() throws ConstructionException {
        throw new NoValueException(this.Valid);
    }

    public void setDefaults() {
        this.setShowName(this.Cn.ShowNames);
        this.setShowValue(this.Cn.ShowValues);
        this.setColor(this.Cn.DefaultColor);
        this.setColorType(this.Cn.DefaultColorType);
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
    }

    public void setTargetDefaults() {
        this.setShowName(this.Cn.ShowNames);
        this.setShowValue(this.Cn.ShowValues);
        this.setColor(this.Cn.DefaultColor);
        this.setColorType(this.Cn.DefaultColorType);
    }

    public boolean contains(PointObject pointObject) {
        return false;
    }

    public boolean canFix() {
        return false;
    }

    public void setFixed(String string) {
    }

    public boolean isBack(boolean bl) {
        if (!bl && this.testConditional("background")) {
            return true;
        }
        return this.Back;
    }

    public boolean isBack() {
        return this.isBack(false);
    }

    public void setBack(boolean bl) {
        this.Back = bl;
    }

    public void setInConstruction(boolean bl) {
        this.inConstruction = bl;
    }

    public boolean isInConstruction() {
        return this.inConstruction;
    }

    public void laterBind(Construction construction) {
    }

    public void laterTranslate(Construction construction) {
    }

    public void setFilled(boolean bl) {
    }

    public boolean isFilled() {
        return false;
    }

    public boolean isFilledForSelect() {
        return this.isFilled();
    }

    public boolean getObtuse() {
        return this.Obtuse;
    }

    public void setObtuse(boolean bl) {
        this.Obtuse = bl;
    }

    public String getDescription() {
        return "";
    }

    public void round() {
    }

    public boolean isFixed() {
        return false;
    }

    public boolean isBreak() {
        return this.Break;
    }

    public void setBreak(boolean bl) {
        this.Break = bl;
        this.HideBreak = false;
    }

    public boolean isHideBreak() {
        return this.HideBreak;
    }

    public void setHideBreak(boolean bl) {
        this.HideBreak = bl;
        this.Break = bl;
    }

    public boolean isSolid(boolean bl) {
        if (!bl && this.testConditional("solid")) {
            return true;
        }
        return this.Solid;
    }

    public boolean isSolid() {
        return this.isSolid(false);
    }

    public void setSolid(boolean bl) {
        this.Solid = bl;
    }

    public boolean maybeTransparent() {
        return false;
    }

    public boolean locallyLike(ConstructionObject constructionObject) {
        return false;
    }

    public int compare(SortObject sortObject) {
        ConstructionObject constructionObject = (ConstructionObject)sortObject;
        if (constructionObject.Value < this.Value) {
            return 1;
        }
        if (constructionObject.Value == this.Value) {
            return 0;
        }
        return -1;
    }

    public void setSelectable(boolean bl) {
        this.Selectable = bl;
    }

    public void snap(ZirkelCanvas zirkelCanvas) {
    }

    public String getUnit() {
        return this.Unit;
    }

    public void setUnit(String string) {
        this.Unit = string;
    }

    public boolean hasUnit() {
        return true;
    }

    public boolean isBreakHide() {
        return this.BreakHide;
    }

    public void setBreakHide(boolean bl) {
        this.BreakHide = bl;
    }

    public String getEquation() {
        return this.getDisplayValue();
    }

    public String helpDisplayValue(boolean bl, double d2, String string) {
        String string2 = "";
        if (Math.abs(d2) < 1.0E-10) {
            return string2;
        }
        if (d2 < 0.0) {
            string2 = "-";
        } else if (!bl) {
            string2 = "+";
        }
        d2 = Math.abs(d2);
        if (Math.abs(d2 - 1.0) > 1.0E-10) {
            string2 = string2 + this.roundDisplay(d2);
        }
        if (string.equals("")) {
            return string2;
        }
        if (string2.equals("") || string2.equals("-")) {
            return string2 + string;
        }
        return string2 + "*" + string;
    }

    public String helpDisplayNumber(boolean bl, double d2) {
        String string = "";
        if (Math.abs(d2) < 1.0E-10) {
            return string;
        }
        if (d2 < 0.0) {
            string = "-";
        } else if (!bl) {
            string = "+";
        }
        d2 = Math.abs(d2);
        return string + this.roundDisplay(d2);
    }

    public boolean visible(ZirkelCanvas zirkelCanvas) {
        return this.selected() || this.ColorType != 3 || zirkelCanvas.showHidden();
    }

    public boolean isBold() {
        return this.Bold;
    }

    public void setBold(boolean bl) {
        this.Bold = bl;
    }

    public boolean isLarge() {
        return this.Large;
    }

    public void setLarge(boolean bl) {
        this.Large = bl;
    }

    public void addConditional(String string, Expression expression) {
        Conditional conditional = new Conditional(string, expression);
        if (this.Conditionals == null) {
            this.Conditionals = new Vector();
        }
        this.Conditionals.addElement(conditional);
    }

    public Expression getConditional(String string) {
        if (this.Conditionals == null) {
            return null;
        }
        Enumeration enumeration = this.Conditionals.elements();
        while (enumeration.hasMoreElements()) {
            Conditional conditional = (Conditional)enumeration.nextElement();
            if (!conditional.getTag().equals(string)) continue;
            return conditional.getExpression();
        }
        return null;
    }

    public boolean haveConditional(String string) {
        Expression expression = this.getConditional(string);
        return expression != null;
    }

    public boolean testConditional(String string) {
        Expression expression = this.getConditional(string);
        if (expression == null) {
            return false;
        }
        try {
            if (expression.getValue() != 0.0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void clearConditionals() {
        this.Conditionals = null;
    }

    public void translateConditionals() {
        if (this.Conditionals != null) {
            Enumeration enumeration = this.Conditionals.elements();
            this.clearConditionals();
            while (enumeration.hasMoreElements()) {
                Conditional conditional = (Conditional)enumeration.nextElement();
                String string = conditional.getExpression().toString();
                Expression expression = new Expression(string, this.getConstruction(), this);
                expression.translate();
                this.addConditional(conditional.getTag(), expression);
            }
        }
        if (this.AliasES != null) {
            this.setAlias(this.AliasES.toString());
            this.AliasES.translate();
        }
    }

    public boolean haveConditionals() {
        return this.Conditionals != null;
    }

    public void checkConditionals() throws ConstructionException {
        if (this.Conditionals == null) {
            return;
        }
        Enumeration enumeration = this.Conditionals.elements();
        while (enumeration.hasMoreElements()) {
            Conditional conditional = (Conditional)enumeration.nextElement();
            if (!conditional.getExpression().isValid()) {
                throw new ConstructionException(conditional.getExpression().getErrorText());
            }
            conditional.getExpression().getValue();
        }
    }

    public double getZ() throws ConstructionException {
        Expression expression = this.getConditional("z");
        if (expression == null) {
            throw new ConstructionException("");
        }
        return expression.getValue();
    }

    public boolean canDisplayName() {
        return true;
    }

    public int getNCount() {
        return this.NCount;
    }

    public void setNCount(int n) {
        this.NCount = n;
    }

    public String getAlias() {
        if (this.AliasES == null) {
            return null;
        }
        return this.AliasES.toString();
    }

    public void setAlias(String string) {
        this.AliasES = string == null ? null : new ExpressionString(string, this);
    }

    public String getElementString(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = this.getName() + " : " + FileName.chop(this.getText(), 80);
                break;
            }
            case 2: {
                string = this.getName() + " : " + FileName.chop(this.getSizeDisplay(), 80);
                break;
            }
            case 1: {
                string = this.getName() + " : " + FileName.chop(this.getEquation(), 80);
            }
        }
        if (this.isSuperHidden()) {
            string = "( " + string + " )";
        }
        if (this.isHideBreak()) {
            string = "** " + string;
        } else if (this.isBreak()) {
            string = "* " + string;
        }
        if (!this.valid()) {
            string = "? " + string;
        }
        if (this instanceof MoveableObject && ((MoveableObject)((Object)this)).moveable()) {
            string = "> " + string;
        }
        return string;
    }

    public String getElementString() {
        return this.getElementString(0);
    }

    public Color getElementColor() {
        if (this.isJobTarget()) {
            return ZirkelFrame.TargetColor;
        }
        if (this.indicated()) {
            return ZirkelFrame.IndicateColor;
        }
        if (this.selected()) {
            return ZirkelFrame.SelectColor;
        }
        return this.getColor();
    }

    public boolean isSpecialParameter() {
        return this.SpecialParameter;
    }

    public void setSpecialParameter(boolean bl) {
        this.SpecialParameter = bl;
    }

    public static PointObject getPointObject(Expression expression) {
        if (expression == null) {
            return null;
        }
        ConstructionObject constructionObject = expression.getObject();
        if (constructionObject == null || !(constructionObject instanceof PointObject)) {
            return null;
        }
        return (PointObject)constructionObject;
    }

    public MyVector getVector() {
        if (this.MVInUse) {
            return new MyVector();
        }
        if (this.MV == null) {
            this.MV = new MyVector();
        }
        this.MVInUse = true;
        return this.MV;
    }

    public void discardMV() {
        this.MVInUse = false;
        this.MV.removeAllElements();
    }
}

