/*
   SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "aitooltextplugineditorinterface.h"
using namespace Qt::Literals::StringLiterals;

#include "textautogeneratetext_version.h"
#include <KActionCollection>
#include <KLocalizedString>
#include <QAction>
#if TEXTAUTOGENERATETEXT_VERSION >= QT_VERSION_CHECK(1, 6, 50)
#include <TextAutoGenerateText/TextAutoGenerateManager>
#include <TextAutoGenerateText/TextAutoGenerateQuickAskDialog>
#else
#include <TextAutoGenerateText/TextAutoGenerateDialog>
#endif

AIToolTextPluginEditorInterface::AIToolTextPluginEditorInterface(QObject *parent)
    : MessageComposer::PluginEditorInterface(parent)
{
}

AIToolTextPluginEditorInterface::~AIToolTextPluginEditorInterface() = default;

void AIToolTextPluginEditorInterface::createAction(KActionCollection *ac)
{
    auto action = new QAction(i18nc("@action", "Open AI Chat"), this);
    ac->addAction(u"open_ai_chat"_s, action);
    connect(action, &QAction::triggered, this, &AIToolTextPluginEditorInterface::slotActivated);
    MessageComposer::PluginActionType type(action, MessageComposer::PluginActionType::Tools);
    setActionType(type);
}

void AIToolTextPluginEditorInterface::slotActivated()
{
    Q_EMIT emitPluginActivated(this);
}

void AIToolTextPluginEditorInterface::exec()
{
#if TEXTAUTOGENERATETEXT_VERSION >= QT_VERSION_CHECK(1, 6, 50)
    auto *manager = new TextAutoGenerateText::TextAutoGenerateManager(this);
    auto d = new TextAutoGenerateText::TextAutoGenerateQuickAskDialog(manager, parentWidget());
#elif TEXTAUTOGENERATETEXT_VERSION >= QT_VERSION_CHECK(1, 6, 45)
    auto d = new TextAutoGenerateText::TextAutoGenerateDialog(parentWidget());
#else
    auto d = new TextAutoGenerateText::TextAutoGenerateDialog;
#endif
    d->setAttribute(Qt::WA_DeleteOnClose);
    d->show();
}

#include "moc_aitooltextplugineditorinterface.cpp"
